# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdvalue import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueEnum(SDValue):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueEnum
        """
        super(SDValueEnum, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sFromValueId(enumTypeId : str, enumValueId : str) -> SDValueEnum:
        """
        Create new value from the specified enum value identifier

        :param enumTypeId: The name of the enum type
        :param enumValueId: The identifier of the enum value
        """
        outSDValueEnum = ctypes.c_void_p()
        _res = sd.getContext().SDValueEnum_sFromValueId(ctypes.create_string_buffer(enumTypeId.encode('utf-8')), ctypes.create_string_buffer(enumValueId.encode('utf-8')), ctypes.byref(outSDValueEnum))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueEnum, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueEnum.value, ownHandle=True)

    @staticmethod
    def sFromValue(enumTypeId : str, enumValue : int) -> SDValueEnum:
        """
        Create new value from the specified enum type Id

        :param enumTypeId: The name of the enum type Id
        :param enumValue: The value of the enum
        """
        outSDValueEnum = ctypes.c_void_p()
        _res = sd.getContext().SDValueEnum_sFromValue(ctypes.create_string_buffer(enumTypeId.encode('utf-8')), enumValue, ctypes.byref(outSDValueEnum))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueEnum, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueEnum.value, ownHandle=True)

    def get(self) -> int:
        """
        Get the value as int

        """
        outValue = ctypes.c_int()
        _res = self.mAPIContext.SDValueEnum_get(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def getValueId(self) -> str:
        """
        Get the value identifier

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDValueEnum_getValueId(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

